################################################################################
# The function fish.proc.two() performs a complete elimination of all genes    #
# which occur in multiple gene functional groups.                              #
#  Input: 1. a gene list 'genes'; each entry itsself is a list of pathway      #
#            names (if a gene is not in any pathway, the entry is 'NA')        #
#         2. the data matrix x                                                 #
#  Output: a vector of gene names that do not belong to more than one pathway  #
################################################################################

fish.proc.two <- function(genes,x){
                 annotx     <- genes[colnames(x)]
                 out        <- colnames(x)[sapply(annotx,length) == 1]
                 names(out) <- unlist(genes[out])
                 return(out)
                 }